<?php

use CodeIgniter\Router\RouteCollection;

/** @var RouteCollection $routes */


// PUBLIC WEBSITE

$routes->get('/', 'Home::index');
$routes->get('/berita', 'Home::berita');
$routes->get('/galeri', 'Home::galeri');
$routes->get('/tentang', 'Home::tentang');

$routes->get('berita/detail/(:num)', 'Berita::detailById/$1');
$routes->get('berita/(:segment)', 'Berita::detail/$1');

$routes->get('berita/download/(:segment)', 'Berita::download/$1');
// atau kalau kamu pakai ID:
$routes->get('berita/download-id/(:num)', 'Berita::downloadById/$1');

$routes->get('kelulusan', 'Kelulusan::index');
$routes->post('kelulusan/cek', 'Kelulusan::cek');
$routes->get('kelulusan/download/(:num)', 'Kelulusan::download/$1');

$routes->get('galeri', 'Galeri::index');
// ADMIN (HARUS LOGIN)

$routes->group('admin', ['filter' => 'sessionauth'], static function ($routes) {
    $routes->get('/', 'Admin\Dashboard::index');

    $routes->get('informasi', 'Admin\Informasi::index');


    // ⬇️ INI YANG KURANG
    $routes->get('branding', 'Admin\Informasi::branding');
    $routes->post('informasi/branding', 'Admin\Informasi::updateBranding');   
    $routes->get('visi-misi', 'Admin\Informasi::visiMisi');
    $routes->post('visi-misi/update', 'Admin\Informasi::updateVisiMisi');
    $routes->get('kepsek', 'Admin\Informasi::kepsek');
    $routes->post('kepsek/update', 'Admin\Informasi::updateKepsek');
    $routes->get('video-profile', 'Admin\Informasi::videoProfile');
    $routes->post('video-profile/update', 'Admin\Informasi::updateVideoProfile');
    $routes->get('data-sekolah', 'Admin\Informasi::dataSekolah');
    $routes->post('data-sekolah/update', 'Admin\Informasi::updateDataSekolah');
    
    $routes->get('pengumuman', 'Admin\Berita::pengumuman');
    $routes->get('pengumuman/create', 'Admin\Berita::createPengumuman');
    $routes->post('pengumuman/store', 'Admin\Berita::storePengumuman');
    $routes->get('pengumuman/edit/(:num)', 'Admin\Berita::editPengumuman/$1');
    $routes->post('pengumuman/update/(:num)', 'Admin\Berita::updatePengumuman/$1');
    $routes->get('pengumuman/delete/(:num)', 'Admin\Berita::deletePengumuman/$1');

    $routes->get('kegiatan',                 'Admin\Berita::kegiatan');
    $routes->get('kegiatann/create',          'Admin\Berita::createKegiatan');
    $routes->post('kegiatan/store',          'Admin\Berita::storeKegiatan');
    $routes->get('kegiatan/edit/(:num)',     'Admin\Berita::editKegiatan/$1');
    $routes->post('kegiatan/update/(:num)',  'Admin\Berita::updateKegiatan/$1');
    $routes->get('kegiatan/delete/(:num)',   'Admin\Berita::deleteKegiatan/$1');

    $routes->get('prestasi',                 'Admin\Berita::prestasi');
    $routes->get('prestasi/create',          'Admin\Berita::createPrestasi');
    $routes->post('prestasi/store',          'Admin\Berita::storePrestasi');
    $routes->get('prestasi/edit/(:num)',     'Admin\Berita::editPrestasi/$1');
    $routes->post('prestasi/update/(:num)',  'Admin\Berita::updatePrestasi/$1');
    $routes->get('prestasi/delete/(:num)',   'Admin\Berita::deletePrestasi/$1');

    $routes->get('kelulusan', 'Admin\Kelulusan::kelulusan');
    $routes->get('kelulusan/create', 'Admin\Kelulusan::create');
    $routes->post('kelulusan/store', 'Admin\Kelulusan::store');
    $routes->get('kelulusan/import', 'Admin\Kelulusan::importForm');
    $routes->post('kelulusan/import', 'Admin\Kelulusan::importCsv');
    $routes->post('kelulusan/reset', 'Admin\Kelulusan::resetByTahun');

    $routes->get('kelulusan/upload-skl', 'Admin\Kelulusan::uploadSklForm');
    $routes->post('kelulusan/upload-skl', 'Admin\Kelulusan::uploadSklZip');

    $routes->get('kelulusan/upload-skl/(:num)', 'Admin\Kelulusan::uploadSklSingleForm/$1');
    $routes->post('kelulusan/upload-skl/(:num)', 'Admin\Kelulusan::uploadSklSingle/$1');
    $routes->post('kelulusan/delete-pdf/(:num)', 'Admin\Kelulusan::deletePdf/$1');

   // LIST
    $routes->get('guru-staf', 'Admin\GaleriGuruStaf::index');
    // CREATE
    $routes->get('guru-staf/create', 'Admin\GaleriGuruStaf::create');
    $routes->post('guru-staf/store', 'Admin\GaleriGuruStaf::store');
    // EDIT
    $routes->get('guru-staf/edit/(:num)', 'Admin\GaleriGuruStaf::edit/$1');
    $routes->post('guru-staf/update/(:num)', 'Admin\GaleriGuruStaf::update/$1');
    // DELETE
    $routes->get('guru-staf/delete/(:num)', 'Admin\GaleriGuruStaf::delete/$1');


        $routes->get('siswa', 'Admin\Siswa::index');
        $routes->get('siswa/create', 'Admin\Siswa::create');
        $routes->post('siswa/store', 'Admin\Siswa::store');
        $routes->get('siswa/edit/(:num)', 'Admin\Siswa::edit/$1');
        $routes->post('siswa/update/(:num)', 'Admin\Siswa::update/$1');
        $routes->get('siswa/delete/(:num)', 'Admin\Siswa::delete/$1');

        $routes->get('video', 'Admin\Video::index');
        $routes->get('video/create', 'Admin\Video::create');
        $routes->post('video/store', 'Admin\Video::store');
        $routes->get('video/delete/(:num)', 'Admin\Video::delete/$1');

        $routes->get('ekstrakurikuler', 'Admin\Ekstrakurikuler::index');
        $routes->get('ekstrakurikuler/create', 'Admin\Ekstrakurikuler::create');
        $routes->post('ekstrakurikuler/store', 'Admin\Ekstrakurikuler::store');
        
        $routes->get('ekstrakurikuler/edit/(:num)', 'Admin\Ekstrakurikuler::edit/$1');
        $routes->post('ekstrakurikuler/update/(:num)', 'Admin\Ekstrakurikuler::update/$1');
        
        $routes->get('ekstrakurikuler/delete/(:num)', 'Admin\Ekstrakurikuler::delete/$1');

        $routes->get('tentang', 'Admin\TentangSekolah::index');
        $routes->get('tentang/create', 'Admin\TentangSekolah::create');
        $routes->post('tentang/store', 'Admin\TentangSekolah::store');
        $routes->get('tentang/edit/(:num)', 'Admin\TentangSekolah::edit/$1');
        $routes->post('tentang/update/(:num)', 'Admin\TentangSekolah::update/$1');
        $routes->get('tentang/delete/(:num)', 'Admin\TentangSekolah::delete/$1');
        
        $routes->get('footer', 'Admin\Footer::index');
        $routes->match(['get','post'], 'footer/update/(:num)', 'Admin\Footer::update/$1');
        $routes->match(['get','post'], 'admin/footer/update/(:num)', 'Admin\Footer::update/$1');

        $routes->get('password', 'Admin\Auth::password');
        $routes->post('password/update', 'Admin\Auth::updatePassword');
        $routes->post('password/update-email', 'Admin\Auth::updateEmail');
    
});



// SHIELD AUTH ROUTES
service('auth')->routes($routes);

